"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

const PARSER_TYPES = {
  N: 'null',
  i: 'int',
  d: 'float',
  b: 'boolean',
  s: 'string',
  a: 'array-object',
  C: 'serializable-class',
  O: 'notserializable-class'
};

class Parser {
  constructor(contents, index, options) {
    this.contents = contents;
    this.index = index;
    this.options = options;
  }

  error(message = 'Syntax Error') {
    return new Error(`${message} at index ${this.index} while unserializing payload`);
  }

  advance(index) {
    this.index += index;
  }

  readAhead(index) {
    const contents = this.peekAhead(index);
    this.index += index;
    return contents;
  }

  readUntil(expected) {
    const index = this.contents.indexOf(expected, this.index);

    if (index === -1) {
      throw this.error(`Expected '${expected}'`);
    }

    return this.readAhead(index - this.index);
  }

  peekAhead(index) {
    return this.contents.toString(this.options.encoding, this.index, this.index + index);
  }

  seekExpected(contents) {
    const slice = this.readAhead(contents.length);

    if (slice !== contents) {
      this.index -= contents.length;
      throw this.error(`Expected '${contents}'`);
    }
  }

  getType() {
    const _this$readAhead = this.readAhead(2),
          _this$readAhead2 = _slicedToArray(_this$readAhead, 2),
          type = _this$readAhead2[0],
          ps = _this$readAhead2[1];

    const parserType = PARSER_TYPES[type];

    if (!parserType) {
      throw this.error('Unknown type');
    }

    if (parserType === 'null' ? ps !== ';' : ps !== ':') {
      throw this.error();
    }

    return parserType;
  }

  getLength() {
    const length = parseInt(this.readUntil(':'), 10);

    if (Number.isNaN(length)) {
      throw this.error();
    }

    return length;
  }

  getByLength(startSequence, endSequence, callback) {
    const length = this.getLength();
    this.seekExpected(`:${startSequence}`);
    const result = callback(length);
    this.seekExpected(endSequence);
    return result;
  }

}

exports.default = Parser;