/// <reference types="node" />
/// <reference types="node" />
import * as stream from 'stream';
import * as tls from 'tls';
export declare type TlsHelloData = {
    serverName: string | undefined;
    alpnProtocols: string[] | undefined;
    fingerprintData: TlsFingerprintData;
};
export declare type TlsFingerprintData = [
    tlsVersion: number,
    ciphers: number[],
    extensions: number[],
    groups: number[],
    curveFormats: number[]
];
/**
 * Seperate error class. If you want to detect TLS parsing errors, but ignore TLS fingerprint
 * issues from definitely-not-TLS traffic, you can ignore all instances of this error.
 */
export declare class NonTlsError extends Error {
    constructor(message: string);
}
export declare function readTlsClientHello(inputStream: stream.Readable): Promise<TlsHelloData>;
export declare function calculateJa3FromFingerprintData(fingerprintData: TlsFingerprintData): string;
export declare function getTlsFingerprintAsJa3(rawStream: stream.Readable): Promise<string>;
declare module 'tls' {
    interface TLSSocket {
        /**
         * This module extends the global TLS types so that all TLS sockets may include
         * TLS fingerprint data.
         *
         * This is only set if the socket came from a TLS server where fingerprinting
         * has been enabled with `trackClientHellos`.
         */
        tlsClientHello?: TlsHelloData & {
            ja3: string;
        };
    }
}
/**
 * Modify a TLS server, so that the TLS client hello is always parsed and the result is
 * attached to all sockets at the point when the 'secureConnection' event fires.
 *
 * This method mutates and returns the TLS server provided. TLS client hello data is
 * available from all TLS sockets afterwards in the `socket.tlsClientHello` property.
 *
 * This will work for all standard uses of a TLS server or similar (e.g. an HTTPS server)
 * but may behave unpredictably for advanced use cases, e.g. if you are already
 * manually injecting connections, hooking methods or events or otherwise doing something
 * funky & complicated. In those cases you probably want to use the fingerprint
 * calculation methods directly inside your funky logic instead.
 */
export declare function trackClientHellos(tlsServer: tls.Server): tls.Server;
