import { SKU } from './types';
export interface SubscriptionPlan {
    paddleId: number;
    name: string;
    prices?: {
        currency: string;
        monthly: string;
        total: string;
    } | 'priceless';
}
export declare const SubscriptionPlans: {
    'pro-monthly': SubscriptionPlan;
    'pro-annual': SubscriptionPlan;
    'team-monthly': SubscriptionPlan;
    'team-annual': SubscriptionPlan;
    'pro-perpetual': SubscriptionPlan;
};
export type SubscriptionPlans = typeof SubscriptionPlans;
export declare function loadPlanPricesUntilSuccess(): Promise<{
    'pro-monthly': SubscriptionPlan;
    'pro-annual': SubscriptionPlan;
    'team-monthly': SubscriptionPlan;
    'team-annual': SubscriptionPlan;
    'pro-perpetual': SubscriptionPlan;
}>;
export declare const getPlanByCode: (sku: SKU) => SubscriptionPlan;
export declare const getSKUForPaddleId: (paddleId: number | undefined) => "pro-monthly" | "pro-annual" | "team-monthly" | "team-annual" | "pro-perpetual" | undefined;
